//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//CutCE 11/2/05  by N.M.Collins 

//for triggering capture events from an event manager CaptureEventsManager

CutCE : CutSynth {
var <>ce, <>func;
	
	*initClass {
	
	StartUp.add({
	
	//mono version
	SynthDef.writeOnce("cutceplaybuf",{arg outbus=0, bufnum=0, offset=0, rate=1.0, len=0.1, amp=1.0; 
var inner;

//need the BufRateScale to cope with Sample Rate differences
inner= amp*PlayBuf.ar(1,bufnum,rate*BufRateScale.kr(bufnum), 1.0, offset, 1.0) 
*Line.ar(1,1,len,doneAction:2);

Out.ar(outbus,inner);
});	
	});
	
	}
	
	//will get Server from BBCutGroup later 
	*new{arg ce,func;  
	
	^super.new.ce_(ce).func_(func);
	}
		
	//can change all rendering functions to return an array of amplitudes? 
	renderBlock {arg block,clock;
		var indices, data, currval;
		
		
		currval= ce.list.size-1;
		
		//if something is in the list
		if(currval>(-0.5),{
		
		indices= func.value(block);
		
		data= Array.fill(indices.size,{arg i; ce.list.wrapAt(indices[i]+(currval))});
		
		block.cuts.do({arg cut,i;
			
			cutgroup.index.postln;
			
			block.msgs[i].add([\s_new, \cutceplaybuf, -1, 0,cutgroup.synthgroup.nodeID,\outbus,cutgroup.index,\bufnum,ce.eventbuf.bufnum,\rate,1.0,\offset,data[i][0],\len,data[i][2],\amp,1.0]);
		
		});
		});
		
		
	}
	//SQPusher1

}